# 機能設計書 5-文字列操作（String Operations）

## 概要

本ドキュメントは、TensorFlowのコアフレームワークにおける文字列操作（String Operations）機能の設計を記述する。文字列の結合・分割・正規表現マッチング・エンコード変換などを提供する。

### 本機能の処理概要

文字列操作機能は、文字列型テンソルに対する各種テキスト処理操作を提供する。正規表現の置換・マッチング、文字列のハッシュ化、結合・分割、大文字/小文字変換、Unicode処理、Base64エンコード/デコードなど、NLP（自然言語処理）パイプラインで必要となる文字列処理を網羅する。

**業務上の目的・背景**：自然言語処理タスクでは、テキストデータの前処理が不可欠である。トークン化、正規表現による文字列クリーニング、ハッシュバケットによるカテゴリカル特徴量の変換など、テキストデータを数値表現に変換するための文字列操作が広範に必要となる。

**機能の利用シーン**：(1) テキスト前処理での正規表現置換・マッチング、(2) 特徴量ハッシュ化（StringToHashBucket）、(3) テキストの結合・分割（StringJoin, StringSplit）、(4) Unicodeテキスト処理、(5) N-gram生成。

**主要な処理内容**：
1. 正規表現: RegexReplace, StaticRegexReplace, RegexFullMatch, StaticRegexFullMatch
2. ハッシュ化: StringToHashBucketFast, StringToHashBucketStrong, StringToHashBucket
3. 結合: StringJoin, ReduceJoin, UnsortedSegmentJoin
4. 分割: StringSplit, StringSplitV2
5. 変換: AsString, StringFormat, StringLower, StringUpper, StringStrip
6. Unicode: UnicodeScript, UnicodeEncode, UnicodeTranscode, UnicodeDecode, UnicodeDecodeWithOffsets
7. エンコード: EncodeBase64, DecodeBase64
8. 部分文字列: Substr
9. N-gram: StringNGrams
10. 長さ取得: StringLength

**関連システム・外部連携**：C++カーネルで実行される。ICU（International Components for Unicode）ライブラリによるUnicode処理を含む。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はコアAPIのため直接的な画面関連はなし |

## 機能種別

計算処理（文字列処理）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input | tf.Tensor(string) | Yes | 入力文字列テンソル | string型であること |
| pattern | tf.Tensor(string) / string | 正規表現操作時 | 正規表現パターン | 有効な正規表現であること |
| rewrite | tf.Tensor(string) / string | RegexReplace時 | 置換文字列 | - |
| num_buckets | int | ハッシュ操作時 | ハッシュバケット数 | 1以上の整数 |
| separator | string | StringJoin時 | 結合区切り文字 | - |

### 入力データソース

Python API呼び出し時の引数として入力される。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| output | tf.Tensor(string) | 処理結果の文字列テンソル |
| output | tf.Tensor(int64) | ハッシュ化結果（ハッシュ操作時） |
| output | tf.Tensor(bool) | マッチング結果（RegexFullMatch時） |

### 出力先

呼び出し元のPythonコードに返却される。

## 処理フロー

### 処理シーケンス

```
1. Python API呼び出し（tf.strings名前空間）
   └─ 入力テンソルのstring型検証
2. 形状推論
   └─ 操作に応じた出力形状計算
3. C++カーネル呼び出し
   └─ 正規表現エンジン / ハッシュ関数 / Unicode処理
4. 結果テンソル返却
```

### フローチャート

```mermaid
flowchart TD
    A[tf.strings API呼び出し] --> B{操作種別}
    B -->|正規表現| C[RE2正規表現エンジン]
    B -->|ハッシュ| D[ハッシュ関数実行]
    B -->|Unicode| E[ICUライブラリ処理]
    B -->|結合/分割| F[文字列操作実行]
    C --> G[結果返却]
    D --> G
    E --> G
    F --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 文字列型制約 | 入力はstring型テンソルのみ | 常時 |
| BR-02 | パターンスカラー制約 | RegexReplace/RegexFullMatchのpatternはスカラー | 動的正規表現操作時 |
| BR-03 | グローバル置換デフォルト | RegexReplaceはデフォルトでグローバル置換 | RegexReplace操作時 |
| BR-04 | ハッシュバケット正整数 | num_bucketsは1以上の整数 | ハッシュ操作時 |

### 計算ロジック

- StringToHashBucketFast: FarmHash64ベースのハッシュ関数
- StringToHashBucketStrong: SipHashベースの暗号学的ハッシュ関数
- RegexReplace: RE2正規表現エンジンによるパターンマッチと置換

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作は発生しない |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArgumentError | 正規表現エラー | 無効な正規表現パターン | 有効なRE2正規表現を使用する |
| TypeError | 型エラー | 非文字列型テンソル | string型テンソルを使用する |
| InvalidArgumentError | ランクエラー | patternが非スカラー | スカラー文字列を使用する |

### リトライ仕様

該当なし。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- 正規表現操作はRE2エンジンにより線形時間で実行されること
- ハッシュ操作は定数時間（O(1) per element）で実行されること

## セキュリティ考慮事項

- StringToHashBucketStrongは暗号学的に強いハッシュを使用（SipHash）
- 正規表現によるReDoS（Regular Expression Denial of Service）はRE2により防止

## 備考

- StaticRegexReplace/StaticRegexFullMatchはパターンをAttrとして持ち、動的版よりも高速
- _TensorToHashBucketFastは内部専用opで、最適化パスで自動生成される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

文字列テンソルの内部表現を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | string_ops.cc | `tensorflow/core/ops/string_ops.cc` | 各opの入出力型定義 |

**読解のコツ**: TensorFlowのstring型はバイト列として内部的に格納される。Unicode処理はICUライブラリに委譲される。

#### Step 2: エントリーポイントを理解する

C++のop定義から各文字列操作の仕様を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | string_ops.cc | `tensorflow/core/ops/string_ops.cc` | REGISTER_OPによる全op定義 |

**主要処理フロー**:
- **38行目**: `RegexReplace` op - 動的正規表現置換（pattern/rewriteがInput）
- **52行目**: `StaticRegexReplace` op - 静的正規表現置換（pattern/rewriteがAttr）
- **60行目**: `RegexFullMatch` op - 動的正規表現マッチング
- **71行目**: `StaticRegexFullMatch` op - 静的正規表現マッチング
- **77行目**: `StringToHashBucketFast` op - FarmHashベースハッシュ化
- **98行目**: `StringToHashBucketStrong` op - SipHashベースハッシュ化
- **111行目**: `ReduceJoin` op - 文字列リダクション結合
- **129行目**: `AsString` op - テンソルの文字列化
- **166行目**: `StringJoin` op - 文字列結合
- **196行目**: `StringSplit` op - 文字列分割
- **232行目**: `StringLower` op - 小文字変換
- **238行目**: `StringUpper` op - 大文字変換
- **244行目**: `StringStrip` op - 空白除去
- **249行目**: `StringLength` op - 文字列長取得
- **255行目**: `EncodeBase64` op - Base64エンコード
- **261行目**: `DecodeBase64` op - Base64デコード
- **266行目**: `Substr` op - 部分文字列取得
- **296行目**: `UnicodeScript` op - Unicodeスクリプト判定
- **301行目**: `UnicodeEncode` op - Unicodeエンコード
- **327行目**: `UnicodeTranscode` op - Unicode変換
- **337行目**: `UnicodeDecode` op - Unicodeデコード
- **383行目**: `StringNGrams` op - N-gram生成

### プログラム呼び出し階層図

```
tf.strings.regex_replace(input, pattern, rewrite)
    |
    +-- gen_string_ops.regex_replace(input, pattern, rewrite)
            |
            +-- C++ RegexReplace kernel
                    |
                    +-- RE2正規表現エンジン
                    +-- UnchangedShape or InputShape(0) (形状推論)
```

### データフロー図

```
[入力]                    [処理]                        [出力]

文字列テンソル      -->  string_ops.cc              -->  結果テンソル
(tf.string)             (形状推論)                      (string/int64/bool)
                            |
                    C++ Kernel
                    (RE2/FarmHash/SipHash/ICU)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| string_ops.cc | `tensorflow/core/ops/string_ops.cc` | ソース | C++ op定義 |
| gen_string_ops.py | `tensorflow/python/ops/gen_string_ops.py` | 自動生成 | Python バインディング |
| common_shape_fns.h | `tensorflow/core/framework/common_shape_fns.h` | ヘッダ | 形状推論関数 |
